/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.matrix.Matrix2;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.referencing.operation.Transformation;

final class LocalizationGridTransform2D
extends AbstractMathTransform
implements MathTransform2D,
Serializable {
    private static final long serialVersionUID = 1067560328828441295L;
    private static final int MAX_ITER = 40;
    private static final boolean CONSERVATIVE = true;
    private static final boolean MASK_NON_CONVERGENCE;
    static final int X_OFFSET = 0;
    static final int Y_OFFSET = 1;
    static final int CP_LENGTH = 2;
    private final int width;
    private final int height;
    private final double[] grid;
    private final AffineTransform global;
    private transient MathTransform2D inverse;

    protected LocalizationGridTransform2D(int width, int height, double[] grid, AffineTransform global) {
        this.width = width;
        this.height = height;
        this.grid = grid;
        this.global = global;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public int getSourceDimensions() {
        return 2;
    }

    @Override
    public int getTargetDimensions() {
        return 2;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    @Override
    public Matrix derivative(Point2D point) {
        AffineTransform tr = new AffineTransform();
        this.getAffineTransform(point.getX(), point.getY(), tr);
        return new Matrix2(tr.getScaleX(), tr.getShearX(), tr.getShearY(), tr.getScaleY());
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        this.transform(srcPts, null, srcOff, dstPts, null, dstOff, numPts);
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        this.transform(null, srcPts, srcOff, null, dstPts, dstOff, numPts);
    }

    private void transform(float[] srcPts1, double[] srcPts2, int srcOff, float[] dstPts1, double[] dstPts2, int dstOff, int numPts) {
        boolean minCol = false;
        boolean minRow = false;
        int maxCol = this.width - 2;
        int maxRow = this.height - 2;
        int postIncrement = 0;
        if (srcOff < dstOff && (srcPts2 != null ? srcPts2 == dstPts2 : srcPts1 == dstPts1)) {
            srcOff += (numPts - 1) * 2;
            dstOff += (numPts - 1) * 2;
            postIncrement = -4;
        }
        while (--numPts >= 0) {
            double yi;
            double xi;
            if (srcPts2 != null) {
                xi = srcPts2[srcOff++];
                yi = srcPts2[srcOff++];
            } else {
                xi = srcPts1[srcOff++];
                yi = srcPts1[srcOff++];
            }
            int col = Math.max(Math.min((int)xi, maxCol), 0);
            int row = Math.max(Math.min((int)yi, maxRow), 0);
            int offset00 = (col + row * this.width) * 2;
            int offset01 = offset00 + 2 * this.width;
            int offset10 = offset00 + 2;
            int offset11 = offset01 + 2;
            double x0 = LocalizationGridTransform2D.linearInterpolation(col + 0, this.grid[offset00 + 0], col + 1, this.grid[offset10 + 0], xi);
            double y0 = LocalizationGridTransform2D.linearInterpolation(col + 0, this.grid[offset00 + 1], col + 1, this.grid[offset10 + 1], xi);
            double x1 = LocalizationGridTransform2D.linearInterpolation(col + 0, this.grid[offset01 + 0], col + 1, this.grid[offset11 + 0], xi);
            double y1 = LocalizationGridTransform2D.linearInterpolation(col + 0, this.grid[offset01 + 1], col + 1, this.grid[offset11 + 1], xi);
            double xf = LocalizationGridTransform2D.linearInterpolation(row, x0, row + 1, x1, yi);
            double yf = LocalizationGridTransform2D.linearInterpolation(row, y0, row + 1, y1, yi);
            if (dstPts2 != null) {
                dstPts2[dstOff++] = xf;
                dstPts2[dstOff++] = yf;
            } else {
                dstPts1[dstOff++] = (float)xf;
                dstPts1[dstOff++] = (float)yf;
            }
            srcOff += postIncrement;
            dstOff += postIncrement;
        }
    }

    private static double linearInterpolation(double x1, double y1, double x2, double y2, double x) {
        return y1 + (y2 - y1) / (x2 - x1) * (x - x1);
    }

    private void getAffineTransform(double x, double y, AffineTransform dest) {
        int sgnRow;
        int sgnCol;
        int col = (int)x;
        int row = (int)y;
        if (col > this.width - 2) {
            col = this.width - 2;
        }
        if (row > this.height - 2) {
            row = this.height - 2;
        }
        if (col < 0) {
            col = 0;
        }
        if (row < 0) {
            row = 0;
        }
        if (x - (double)col > 0.5) {
            sgnCol = -1;
            ++col;
        } else {
            sgnCol = 1;
        }
        if (y - (double)row > 0.5) {
            sgnRow = -1;
            ++row;
        } else {
            sgnRow = 1;
        }
        int offset00 = (col + row * this.width) * 2;
        int offset01 = offset00 + sgnRow * 2 * this.width;
        int offset10 = offset00 + sgnCol * 2;
        x = this.grid[offset00 + 0];
        y = this.grid[offset00 + 1];
        double dxCol = (this.grid[offset10 + 0] - x) * (double)sgnCol;
        double dyCol = (this.grid[offset10 + 1] - y) * (double)sgnCol;
        double dxRow = (this.grid[offset01 + 0] - x) * (double)sgnRow;
        double dyRow = (this.grid[offset01 + 1] - y) * (double)sgnRow;
        dest.setTransform(dxCol, dyCol, dxRow, dyRow, x - dxCol * (double)col - dxRow * (double)row, y - dyCol * (double)col - dyRow * (double)row);
        assert (this.distance(new Point(col, row), dest) < 1.0E-5);
        assert (this.distance(new Point(col + sgnCol, row), dest) < 1.0E-5);
        assert (this.distance(new Point(col, row + sgnRow), dest) < 1.0E-5);
    }

    private double distance(Point2D index, AffineTransform tr) {
        try {
            Point2D geoCoord = this.transform(index, null);
            geoCoord = tr.inverseTransform(geoCoord, geoCoord);
            return geoCoord.distance(index);
        }
        catch (TransformException exception) {
            throw new AssertionError((Object)exception);
        }
        catch (NoninvertibleTransformException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    final void inverseTransform(Point2D source, Point2D.Double target, AffineTransform tr) throws TransformException {
        tr.setTransform(this.global);
        try {
            double y;
            double x;
            tr.inverseTransform(source, target);
            int previousX = (int)target.x;
            int previousY = (int)target.y;
            for (int iter = 0; iter < 40; ++iter) {
                this.getAffineTransform(target.x, target.y, tr);
                tr.inverseTransform(source, target);
                int ix = (int)target.x;
                int iy = (int)target.y;
                if (previousX == ix && previousY == iy) {
                    if (target.x >= 0.0 && target.x < (double)this.width && target.y >= 0.0 && target.y < (double)this.height) {
                        assert (this.transform(target, null).distanceSq(source) < 0.001) : target;
                    } else {
                        this.inverseTransform(source, target);
                    }
                    return;
                }
                previousX = ix;
                previousY = iy;
            }
            int x0 = previousX;
            int y0 = previousY;
            this.global.inverseTransform(source, target);
            double bestX = x = target.x;
            double bestY = y = target.y;
            double minSq = Double.POSITIVE_INFINITY;
            for (int iter = -39; iter < 40; ++iter) {
                previousX = (int)x;
                previousY = (int)y;
                this.getAffineTransform(x, y, tr);
                tr.inverseTransform(source, target);
                x = target.x;
                y = target.y;
                int ix = (int)x;
                int iy = (int)y;
                if (previousX == ix && previousY == iy) {
                    assert (iter >= 0);
                    if (x >= 0.0 && x < (double)this.width && y >= 0.0 && y < (double)this.height) {
                        assert (this.transform(target, null).distanceSq(source) < 0.001) : target;
                    } else {
                        this.inverseTransform(source, target);
                    }
                    return;
                }
                if (iter == 0) {
                    assert (x0 == ix && y0 == iy);
                } else if (x0 == ix && y0 == iy) {
                    if (bestX >= 0.0 && bestX < (double)this.width && bestY >= 0.0 && bestY < (double)this.height) {
                        target.x = bestX;
                        target.y = bestY;
                    } else {
                        this.inverseTransform(source, target);
                    }
                    return;
                }
                this.transform(target, target);
                double distanceSq = target.distanceSq(source);
                if (!(distanceSq < minSq)) continue;
                minSq = distanceSq;
                bestX = x;
                bestY = y;
            }
            if (MASK_NON_CONVERGENCE) {
                Logging.getLogger(LocalizationGridTransform2D.class).fine("No convergence");
                if (bestX >= 0.0 && bestX < (double)this.width && bestY >= 0.0 && bestY < (double)this.height) {
                    target.x = bestX;
                    target.y = bestY;
                } else {
                    this.inverseTransform(source, target);
                }
                return;
            }
        }
        catch (NoninvertibleTransformException exception) {
            TransformException e = new TransformException(Errors.format((int)105));
            e.initCause((Throwable)exception);
            throw e;
        }
        throw new TransformException(Errors.format((int)129));
    }

    private void inverseTransform(Point2D source, Point2D.Double target) throws NoninvertibleTransformException {
        if (this.global.inverseTransform(source, target) != target) {
            throw new AssertionError();
        }
        double x = target.x;
        double y = target.y;
        if (x >= 0.0 && x < (double)this.width && y >= 0.0 && y < (double)this.height) {
            x -= 0.5 * (double)this.width;
            y -= 0.5 * (double)this.height;
            if (Math.abs(x) < Math.abs(y)) {
                target.x = x > 0.0 ? (double)this.width : -1.0;
            } else {
                target.y = y > 0.0 ? (double)this.height : -1.0;
            }
        }
    }

    public MathTransform2D inverse() {
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    @Override
    public int hashCode() {
        return 0x801E52CF ^ super.hashCode() ^ this.global.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            LocalizationGridTransform2D that = (LocalizationGridTransform2D)object;
            return this.width == that.width && this.height == that.height && Utilities.equals((Object)this.global, (Object)that.global) && Arrays.equals(this.grid, that.grid);
        }
        return false;
    }

    static {
        String property;
        try {
            property = System.getProperty("org.geotools.referencing.forceConvergence", "false");
        }
        catch (SecurityException exception) {
            property = "false";
        }
        MASK_NON_CONVERGENCE = property.equalsIgnoreCase("true");
    }

    private static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -8263439392080019340L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "WarpPolynomial")}, (GeneralParameterDescriptor[])new ParameterDescriptor[0]);

        public Provider() {
            super(2, 2, PARAMETERS);
        }

        public Class<Transformation> getOperationType() {
            return Transformation.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException, FactoryException {
            throw new FactoryException("Not yet implemented");
        }
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements MathTransform2D,
    Serializable {
        private static final long serialVersionUID = 4876426825123740986L;

        @Override
        public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
            AffineTransform tr = new AffineTransform(LocalizationGridTransform2D.this.global);
            if (ptDst == null) {
                Point2D.Double target = new Point2D.Double();
                LocalizationGridTransform2D.this.inverseTransform(ptSrc, target, tr);
                return target;
            }
            if (ptDst != ptSrc && ptDst instanceof Point2D.Double) {
                LocalizationGridTransform2D.this.inverseTransform(ptSrc, (Point2D.Double)ptDst, tr);
                return ptDst;
            }
            Point2D.Double target = new Point2D.Double();
            LocalizationGridTransform2D.this.inverseTransform(ptSrc, target, tr);
            ptDst.setLocation(target);
            return ptDst;
        }

        @Override
        public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
            int postIncrement = 0;
            if (srcPts == dstPts && srcOff < dstOff) {
                srcOff += (numPts - 1) * 2;
                dstOff += (numPts - 1) * 2;
                postIncrement = -4;
            }
            Point2D.Double source = new Point2D.Double();
            Point2D.Double target = new Point2D.Double();
            AffineTransform tr = new AffineTransform(LocalizationGridTransform2D.this.global);
            while (--numPts >= 0) {
                source.x = srcPts[srcOff++];
                source.y = srcPts[srcOff++];
                LocalizationGridTransform2D.this.inverseTransform(source, target, tr);
                dstPts[dstOff++] = (float)target.x;
                dstPts[dstOff++] = (float)target.y;
                srcOff += postIncrement;
                dstOff += postIncrement;
            }
        }

        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            int postIncrement = 0;
            if (srcPts == dstPts && srcOff < dstOff) {
                srcOff += (numPts - 1) * 2;
                dstOff += (numPts - 1) * 2;
                postIncrement = -4;
            }
            Point2D.Double source = new Point2D.Double();
            Point2D.Double target = new Point2D.Double();
            AffineTransform tr = new AffineTransform(LocalizationGridTransform2D.this.global);
            while (--numPts >= 0) {
                source.x = srcPts[srcOff++];
                source.y = srcPts[srcOff++];
                LocalizationGridTransform2D.this.inverseTransform(source, target, tr);
                dstPts[dstOff++] = target.x;
                dstPts[dstOff++] = target.y;
                srcOff += postIncrement;
                dstOff += postIncrement;
            }
        }

        public MathTransform2D inverse() {
            return (MathTransform2D)super.inverse();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            LocalizationGridTransform2D.this.inverse = this;
        }
    }
}

