/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.geotools.feature.FeatureCollection;

public class EMFUtils {
    public static boolean has(EObject eobject, String property) {
        return EMFUtils.feature(eobject, property) != null;
    }

    public static void set(EObject eobject, String property, Object value) {
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        eobject.eSet(feature, value);
    }

    public static Object get(EObject eobject, String property) {
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        return eobject.eGet(feature);
    }

    public static Object getFromMap(EObject eobject, String property, Object key) {
        Map map = (Map)EMFUtils.get(eobject, property);
        return map.get(key);
    }

    public static Object getFromMapSafe(EObject eobject, String property, String key) {
        if (!EMFUtils.has(eobject, property)) {
            return null;
        }
        Object o = EMFUtils.get(eobject, property);
        if (o == null || !(o instanceof Map)) {
            return null;
        }
        return ((Map)o).get(key);
    }

    public static void add(EObject eobject, String property, Object value) {
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        if (feature != null) {
            EMFUtils.add(eobject, feature, value);
        }
    }

    public static void add(EObject eobject, EStructuralFeature feature, Object value) {
        if (EMFUtils.isCollection(eobject, feature)) {
            Collection collection = (Collection)eobject.eGet(feature);
            if (collection == null) {
                collection = EMFUtils.createEmptyCollection(feature);
                eobject.eSet(feature, (Object)collection);
            }
            Collection addCollection = EMFUtils.collection(value);
            collection.addAll(addCollection);
        }
    }

    static Collection createEmptyCollection(EStructuralFeature feature) {
        Class clazz = feature.getEType().getInstanceClass();
        if (EList.class.isAssignableFrom(clazz)) {
            return new BasicEList();
        }
        if (List.class.isAssignableFrom(clazz)) {
            return new ArrayList();
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return new HashSet();
        }
        throw new IllegalArgumentException("Unable to create collection for " + clazz);
    }

    private static Collection collection(Object value) {
        if (null == value) {
            return Collections.EMPTY_LIST;
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                Object val = Array.get(value, i);
                list.add(val);
            }
            return list;
        }
        if (value instanceof FeatureCollection) {
            return Collections.singletonList(value);
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return Collections.singletonList(value);
    }

    public static boolean isCollection(EObject eobject, String property) {
        Object o = EMFUtils.get(eobject, property);
        if (o != null) {
            return o instanceof Collection;
        }
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        if (feature == null) {
            return false;
        }
        return EMFUtils.isCollection(eobject, feature);
    }

    public static boolean isCollection(EObject eobject, EStructuralFeature feature) {
        Object o = eobject.eGet(feature);
        if (o != null) {
            return o instanceof Collection;
        }
        return Collection.class.isAssignableFrom(feature.getEType().getInstanceClass());
    }

    public static EStructuralFeature feature(EObject eobject, String property) {
        EStructuralFeature feature2 = eobject.eClass().getEStructuralFeature(property);
        if (feature2 != null) {
            return feature2;
        }
        for (EStructuralFeature feature2 : eobject.eClass().getEAllStructuralFeatures()) {
            if (!feature2.getName().equalsIgnoreCase(property)) continue;
            return feature2;
        }
        return null;
    }

    public static List features(EObject eobject, Class propertyType) {
        ArrayList<EStructuralFeature> match = new ArrayList<EStructuralFeature>();
        EList features = eobject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            if (!feature.getEType().getInstanceClass().isAssignableFrom(propertyType)) continue;
            match.add(feature);
        }
        return match;
    }

    public static void set(List objects, String property, List values) {
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            EMFUtils.set(eobject, property, values.get(i));
        }
    }

    public static void set(List objects, String property, Object value) {
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            EMFUtils.set(eobject, property, value);
        }
    }

    public static List get(List objects, String property) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            EStructuralFeature feature = EMFUtils.feature(eobject, property);
            values.add(eobject.eGet(feature));
        }
        return values;
    }

    public static boolean isSet(EObject eobject, String property) {
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        return eobject.eIsSet(feature);
    }

    public static boolean isSet(List objects, String property) {
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            if (EMFUtils.isSet(eobject, property)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnset(List objects, String property) {
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            if (!EMFUtils.isSet(eobject, property)) continue;
            return false;
        }
        return true;
    }

    public static EObject clone(EObject prototype, EFactory factory) {
        return EMFUtils.clone(prototype, factory, false);
    }

    public static EObject clone(EObject prototype, EFactory factory, boolean deep) {
        EObject clone = factory.create(prototype.eClass());
        for (EStructuralFeature feature : clone.eClass().getEStructuralFeatures()) {
            Object value = prototype.eGet(feature);
            if (deep && value instanceof EObject) {
                EObject evalue = (EObject)value;
                value = EMFUtils.clone(evalue, evalue.eClass().getEPackage().getEFactoryInstance(), deep);
            }
            clone.eSet(feature, value);
        }
        return clone;
    }

    public static void copy(EObject source, EObject target) {
        for (EStructuralFeature feature : source.eClass().getEStructuralFeatures()) {
            target.eSet(feature, source.eGet(feature));
        }
    }
}

